string[] words = "The quick brown fox jumps over the lazy dog".Split();
Random rand = new Random(0);

using (Stream s = File.Create ("compressed.bin"))
using (Stream ds = new BrotliStream (s, CompressionMode.Compress))
using (TextWriter w = new StreamWriter (ds))
	for (int i = 0; i < 1000; i++)
		await w.WriteAsync (words [rand.Next (words.Length)] + " ");

new FileInfo ("compressed.bin").Length.Dump ("Rozmiar skompresowanego pliku");

using (Stream s = File.OpenRead ("compressed.bin"))
using (Stream ds = new BrotliStream (s, CompressionMode.Decompress))
using (TextReader r = new StreamReader (ds))
	Console.Write (await r.ReadToEndAsync());  // Wynik poniżej: